﻿//using System;
//using System.Threading.Tasks;
//using Microsoft.Extensions.Logging;
//using Microsoft.VisualBasic.FileIO;
//using Microsoft.Xrm.Sdk;
//using VA.PPMS.Context;
//using VA.PPMS.Context.Interface;
//using VA.PPMS.IWS.TableService.Interface.Entities;
//using VA.PPMS.IWS.ValidationDataService.Helpers;

//namespace VA.PPMS.IWS.ValidationDataService.Data
//{
//    public class LeieData
//    {
//        private readonly ILogger<LeieData> _logger;
//        private readonly IPpmsContextHelper _ppmsContextHelper;

//        public LeieData(ILoggerFactory loggerFactory, IPpmsContextHelper ppmsContextHelper)
//        {
//            _logger = loggerFactory.CreateLogger<LeieData>();
//            _ppmsContextHelper = ppmsContextHelper;
//        }

//        public async Task SaveFileAsync(string filePath)
//        {
//            const string delimiter = ",";

//            try
//            {
//                var i = 1;
//                var initialTime = DateTime.Now;
                
//                using (var parser = new TextFieldParser(filePath))
//                {
//                    parser.HasFieldsEnclosedInQuotes = true;
//                    parser.SetDelimiters(delimiter);

//                    string[] columns;
//                    while ((columns = parser.ReadFields()) != null)
//                    {
//                        if (i > 1 && columns.Length >= LeieExclusionEntity.ColumnSize)
//                        {
//                            _logger.LogInformation($"Processing item {i}");
//                            await SaveLeieBatch(new LeieExclusionEntity(columns));
//                        }

//                        i++;
//                    }
//                }

//                _logger.LogInformation($"Totals: Active={i}");
//                _logger.LogInformation($"Elapsed time: {DateTime.Now.Subtract(initialTime).TotalMinutes}");
//            }
//            catch (Exception ex)
//            {
//                _logger.LogError($"Error LeieData: {ex}");
//            }
//        }

//        private async Task SaveLeieBatch(LeieExclusionEntity item)
//        {
//            if (item.IsValid)
//            {
//                using (var context = await _ppmsContextHelper.GetOrganizationServiceProxyAsync())
//                {
//                    var detail = new Entity("ppms_leieexclusion");
//                    detail.Attributes.Add("ppms_action", new OptionSetValue((int)PpmsHelper.LeieAction_Type.Exclude));
//                    detail.Attributes.Add("ppms_lastname", item.LastName);
//                    detail.Attributes.Add("ppms_firstname", item.FirstName);
//                    detail.Attributes.Add("ppms_middlename", item.MidName);
//                    detail.Attributes.Add("ppms_busiinessname", item.BusName);
//                    detail.Attributes.Add("ppms_npi", item.Npi);
//                    detail.Attributes.Add("ppms_dob", EntityHelper.ConvertToDate(item.Dob, true));
//                    detail.Attributes.Add("ppms_address", item.Address);
//                    detail.Attributes.Add("ppms_city", item.City);
//                    detail.Attributes.Add("ppms_state", item.State);
//                    detail.Attributes.Add("ppms_zip", item.Zip);
//                    detail.Attributes.Add("ppms_exclusiontype1", EntityHelper.GetLeieExclusionAuthority(context, item.ExclusionType));
//                    detail.Attributes.Add("ppms_exclusiondate", EntityHelper.ConvertToDate(item.ExclusionDate, true));
//                    detail.Attributes.Add("ppms_reinstatedate", EntityHelper.ConvertToDate(item.ReinstateDate, true));
//                    detail.Attributes.Add("ppms_waiverdate", EntityHelper.ConvertToDate(item.WaiverDate, true));
//                    detail.Attributes.Add("ppms_waiverstate", item.WaiverState);
//                    context.Create(detail);
//                }
//            }
//        }
//    }
//}